from functools import wraps
from telegram import ChatAction, Update
from telegram.ext import CallbackContext

# decorator for sending typing chat action
def send_typing_action(func):
    """Sends typing action while processing func command."""

    @wraps(func)
    def command_func(update:Update, context:CallbackContext, *args, **kwargs):
        context.bot.send_chat_action(chat_id=update.effective_message.chat_id, action=ChatAction.TYPING)
        return func(update, context,  *args, **kwargs)

    return command_func